<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePDSHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('pds_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('service_record_id')->nullable();
            $table->unsignedBigInteger('eefc_id');
            $table->string('field_name');
            $table->string('field_value');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('service_record_id')->references('id')->on(env('ADG_DB_DATABASE').'.service_records');
            $table->foreign('eefc_id')->references('id')->on(env('ADG_DB_DATABASE').'.employee_extra_field_columns');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('pds_histories');
    }
}
