<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServiceRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('service_records', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->unsignedBigInteger('position_id');
            $table->double('salary');
            $table->double('allowance');
            $table->unsignedBigInteger('employee_type_id');
            $table->unsignedBigInteger('division_id');
            $table->unsignedBigInteger('remark_id');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by');

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('position_id')->references('id')->on(env('HRJP_DB_DATABASE').'.positions');
            $table->foreign('employee_type_id')->references('id')->on(env('ADG_DB_DATABASE').'.employee_types');
            $table->foreign('division_id')->references('id')->on(env('ADG_DB_DATABASE') . '.divisions');
            $table->foreign('remark_id')->references('id')->on(env('ADG_DB_DATABASE') . '.remarks');

            $table->timestamps();
            $table->softDeletes();
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('service_records');
    }
}
