<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterRescheduleRequestDatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_reschedule_request_dates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('request_id');
            $table->unsignedBigInteger('roster_day_id');
            $table->unsignedBigInteger('shift_id');
            $table->unsignedBigInteger('old_shift');

            $table->foreign('request_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_reschedule_requests');
            $table->foreign('roster_day_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_days');
            $table->foreign('shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_reschedule_request_dates');
    }
}
