<?php

use App\Enums\ApprovedStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterRescheduleRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_reschedule_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->date('request_date');
            $table->text('reason')->nullable();
            $table->tinyInteger('status')->comment('1 = approved, 2 = declined, 3 = pending')->default(ApprovedStatus::PENDING);

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_reschedule_requests');
    }
}
