<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterDayEmployeeShiftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_day_employee_shifts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('shift_id');
            $table->unsignedBigInteger('roster_day_id');
            $table->unsignedBigInteger('roster_legend_id');

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('shift_id')->references('id')->on(env('ADG_DB_DATABASE') . '.shifts');
            $table->foreign('roster_day_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_days');
            $table->foreign('roster_legend_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_legends');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_day_employee_shifts');
    }
}
