<?php

use App\Enums\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterLegendsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_legends', function (Blueprint $table) {
            $table->id(); 
            $table->string('key', 100);
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('color', 15);
            $table->tinyInteger('status')->comment('1 = active, 2 = inactive')->default(Status::ACTIVE);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_legends');
    }
}
