<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterDaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_days', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('roster_partition_id');
            $table->date('date');
            $table->tinyInteger('day')->comment('0 = sunday, 1 = monday, 2 = tuesday, 3 = wednesday, 4 = thursday, 5 = friday, 6 = saturday');
            
            $table->foreign('roster_partition_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_partitions');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_days');
    }
}
