<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterEmployeeGroupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_employee_groups', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('roster_id');
            $table->string('group_name')->comment('Name of group position such as Nurses, Nursing attendants etc');
            $table->text('description')->nullable();
            $table->unsignedBigInteger('mornint_shift_primary');
            $table->unsignedBigInteger('morning_shift_secondary');
            $table->unsignedBigInteger('night_shift_primary');
            $table->unsignedBigInteger('night_shift_secondary');

            $table->foreign('roster_id')->references('id')->on(env('ADG_DB_DATABASE') . '.rosters');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_employee_groups');
    }
}
