<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterPartitionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('roster_partitions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('roster_id');
            $table->integer('number_of_weeks')->default(1);
            $table->date('start_date');
            $table->date('end_date');
            $table->integer('required_work_hours');

            $table->foreign('roster_id')->references('id')->on(env('ADG_DB_DATABASE') . '.rosters');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('roster_partitions');
    }
}
