<?php

use App\Enums\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRostersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('rosters', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('department_id');
            $table->unsignedBigInteger('division_id');
            $table->unsignedBigInteger('head_nurse_id');
            $table->string('title');
            $table->text('description')->nullable();
            $table->integer('number_of_weeks')->default(1);
            $table->date('start_date');
            $table->date('end_date');
            $table->tinyInteger('status')->comment('1 = active, 2 = inactive')->default(Status::ACTIVE);

            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE') . '.departments');
            $table->foreign('division_id')->references('id')->on(env('ADG_DB_DATABASE') . '.divisions');
            $table->foreign('head_nurse_id')->references('id')->on(env('DB_DATABASE') . '.users');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('rosters');
    }
}
