<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePDSPerPositionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('pds_per_positions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('position_history_id')->nullable();
            $table->unsignedBigInteger('eefc_id');
            $table->string('field_name');
            $table->string('field_value')->nullable();
            $table->integer('created_by');
            $table->timestamps();
            $table->integer('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('position_history_id')->references('id')->on(env('HRJP_DB_DATABASE').'.position_histories');
            $table->foreign('eefc_id')->references('id')->on(env('ADG_DB_DATABASE'). '.employee_extra_field_columns');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('pds_per_positions');
    }
}
