<?php

use App\Enums\Biometrics\EnabledStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBiometricDevicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('biometric_devices', function (Blueprint $table) {
            $table->id();
            $table->string('name', 150);
            $table->text('description')->nullable();
            $table->string('host', 129);
            $table->string('port', 20)->default('4370');
            $table->unsignedBigInteger('department_id');
            $table->unsignedBigInteger('division_id');
            $table->tinyInteger('status')->comment('1 = enabled, 2 = disabled')->default(EnabledStatus::ENABLED);

            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE') . '.departments');
            $table->foreign('division_id')->references('id')->on(env('ADG_DB_DATABASE') . '.divisions');
            
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('biometric_devices');
    }
}
