<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateAttendanceForeignKeyConstraints extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('attendances', function(Blueprint $table) {
            $table->dropForeign(['timetable_id']);
            $table->dropForeign(['schedule_day_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('attendances', function(Blueprint $table) {
            $table->foreign('timetable_id')->references('id')->on(env('ADG_DB_DATABASE') . '.timetables');
            $table->foreign('schedule_day_id')->references('id')->on(env('ADG_DB_DATABASE') . '.schedule_templates');
        });
    }
}
