<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEmployeePayrollVoidStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('payroll_employees', function(Blueprint $table) {
            $table->tinyInteger('void_status')->comment('1 = voided, 0 = not voided')->default(0)->after('net_pay');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('payroll_employees', function(Blueprint $table) {
            $table->dropColumn(['void_status']);
        });
    }
}
