<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAttendancePunchTypeColumn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('attendances', function(Blueprint $table) {
            $table->tinyInteger('time_in_state')->comment('1 = fingerprint, 2 = rfid/card, 16 = face, 0 = password, 5 = system')->default(5)->after('type');
            $table->tinyInteger('time_out_state')->comment('1 = fingerprint, 2 = rfid/card, 16 = face, 0 = password, 5 = system')->default(5)->nullable()->after('time_in_state');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('attendances', function(Blueprint $table) {
            $table->dropColumn(['time_in_state', 'time_out_state']);
        });
    }
}
