<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFingerprintsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('fingerprints', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('biometric_id');
            $table->tinyInteger('finger_number')->default(6);
            $table->binary('fingerprint_template')->nullable();
            $table->foreign('biometric_id')->references('id')->on(env('ADG_DB_DATABASE') . '.biometrics');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('fingerprints');
    }
}
