<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateBiometricsRfidTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('biometrics', function(Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropColumn(['user_id']);
            $table->unsignedBigInteger('biometric_rfid_id')->after('id');
            $table->foreign('biometric_rfid_id')->references('id')->on(env('ADG_DB_DATABASE') . '.biometric_rfid_users');
        });

        Schema::connection('adg_db')->table('rfid', function(Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropColumn(['user_id']);
            $table->string('card_number', 11)->nullable()->change();
            $table->unsignedBigInteger('biometric_rfid_id')->after('id');
            $table->foreign('biometric_rfid_id')->references('id')->on(env('ADG_DB_DATABASE') . '.biometric_rfid_users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('biometrics', function(Blueprint $table) {
            $table->dropForeign(['biometric_rfid_id']);
            $table->dropColumn(['biometric_rfid_id']);
            $table->unsignedBigInteger('user_id')->after('id');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
        });

        Schema::connection('adg_db')->table('rfid', function(Blueprint $table) {
            $table->dropForeign(['biometric_rfid_id']);
            $table->dropColumn(['biometric_rfid_id']);
            $table->unsignedBigInteger('user_id')->after('id');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }
}
