<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNewUpdatesPds extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('new_updates_pds', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('eefc_id');
            $table->unsignedBigInteger('position_id')->nullable();
            $table->string('field_value')->nullable();
            $table->string('old_value')->nullable();
            $table->integer('status')->comment('1 = approve, 2 = decline, 3 = pending')->default(3);
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('eefc_id')->references('id')->on(env('ADG_DB_DATABASE'). '.employee_extra_field_columns');
            $table->foreign('position_id')->references('id')->on(env('HRJP_DB_DATABASE').'.positions');
        }); 
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('new_updates_pds');
    }
}
