<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateAttendancesDatetimeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('attendances', function(Blueprint $table) {
            $table->dropColumn(['legend']);
            $table->dateTime('time_in')->change();
            $table->dateTime('time_out')->nullable()->change();
            $table->date('date_in')->nullable()->change();
            $table->unsignedBigInteger('timetable_id')->after('time_out')->nullable();
            $table->unsignedBigInteger('schedule_day_id')->after('timetable_id')->nullable();
            $table->foreign('timetable_id')->references('id')->on(env('ADG_DB_DATABASE') . '.timetables');
            $table->foreign('schedule_day_id')->references('id')->on(env('ADG_DB_DATABASE') . '.schedule_templates');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('attendances', function(Blueprint $table) {
            $table->time('time_in')->change();
            $table->time('time_out')->nullable()->change();
            $table->date('date_in')->change();
            $table->tinyInteger("legend")->comment('1 = standard, 2 = overtime, 3 = undertime, 4 = late')->after('remarks');
            $table->dropForeign(['schedule_day_id']);
            $table->dropColumn('schedule_day_id');
            $table->dropForeign(['timetable_id']);
            $table->dropColumn('timetable_id');
        });
    }
}
