<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateScheduleTemplatePolymorphicTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('schedule_templates', function(Blueprint $table) {
            $table->morphs('schedulable');
            $table->dropForeign(['title_id']);
            $table->dropColumn(['title_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('schedule_templates', function(Blueprint $table) {
            $table->dropMorphs('schedulable');
            $table->unsignedBigInteger('title_id')->after('id');
            $table->foreign('title_id')->references('id')->on(env('ADG_DB_DATABASE') . '.schedule_titles');
        });
    }
}
