<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveForCancellationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::connection(env('ADG_DB_CONNECTION'))->create('leave_for_cancellations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('leave_id');
            $table->unsignedBigInteger('leave_type_id');
            $table->integer('old_leave_status');
            $table->integer('status')->comment('1 = approved, 2 = declined, 3 = pending')->default(3);
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('leave_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leaves');
            $table->foreign('leave_type_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_types');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('leave_for_cancellations');
    }
}
