<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateLeavesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('leaves', function(Blueprint $table){
            $table->integer('status')->comment('1 = approved, 2 = declined, 3 = for review, 4 = cancelled, 5 = for cancellation')->default(3)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('leaves', function(Blueprint $table){
            $table->dropColumn('status');
        });
    }
}
