<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateScheduleTemplateTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('schedule_templates', function(Blueprint $table) {
            $table->dropColumn(['time_start', 'time_end', 'max_time', 'minutes']);
            $table->dropSoftDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('schedule_templates', function(Blueprint $table) {
            $table->time('time_start')->after('day');
            $table->time('time_end')->nullable()->after('time_start');
            $table->time('max_time')->nullable()->after('time_end');
            $table->integer('minutes')->nullable()->after('max_time');
            $table->softDeletes();
        });
    }
}
