<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScheduleTemplateTimetableTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('schedule_template_timetable', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('schedule_template_id');
            $table->unsignedBigInteger('timetable_id');

            $table->foreign('schedule_template_id')->references('id')->on(env('ADG_DB_DATABASE') . '.schedule_templates');
            $table->foreign('timetable_id')->references('id')->on(env('ADG_DB_DATABASE') . '.timetables');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('schedule_template_timetable');
    }
}
