<?php

use App\Enums\ShiftType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTimetablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('timetables', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->time('time_in');
            $table->time('max_time')->nullable();
            $table->time('time_out');
            $table->integer('minutes');
            $table->tinyInteger('status')->comment('1 = active, 2 = inactive');
            $table->tinyInteger('shift_type')->comment('1 = day shift, 2 = night shift, 3 = straight')->default(ShiftType::DAY);
            $table->decimal('work_day')->comment('Work day by decimal. 1 = 1 workday. 0.5 = half day');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('timetables');
    }
}
