<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateScheduleTitles extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->table('schedule_titles', function(Blueprint $table){
            $table->integer('active_schedule')->comment('1 = current active schedule, 0 = inactive schedule')->default(0)->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->table('schedule_titles', function(Blueprint $table){
            $table->dropColumn('active_schedule');
        });
    }
}
