<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDesignationHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('designation_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('corp_id');
            $table->unsignedBigInteger('branch_id');
            $table->unsignedBigInteger('division_id');
            $table->unsignedBigInteger('department_id');
            $table->date('date_of_designation');
            $table->integer('status')->comment('1 = current, 2 = previous')->default(1);
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('corp_id')->references('id')->on(env('ADG_DB_DATABASE').'.corporations');
            $table->foreign('branch_id')->references('id')->on(env('ADG_DB_DATABASE').'.branches');
            $table->foreign('division_id')->references('id')->on(env('ADG_DB_DATABASE').'.divisions');
            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE').'.departments');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('designation_histories');
    }
}
