<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRFIDSTable extends Migration
{
   
    public function up()
    {
        Schema::connection('adg_db')->create('rfid', function (Blueprint $table) {
            $table->id();
            $table->unsignedbigInteger('user_id');
            $table->string('rfid', 12);
            $table->string('card_number', 12);
            $table->tinyInteger('status')->comment('1 - active , 2 - inactive');
            $table->date('date_issued');
            $table->BigInteger('created_by');
            $table->BigInteger('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');

        });
    }


    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('rfid');
    }
}
