<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBiometricsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('biometrics', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->tinyInteger('type')->comment('1 = fingerprint, 2 = face');
            $table->string('biometric_number', 12);
            $table->tinyInteger('status')->comment('1 = active, 2 = inactive');
            $table->date('date_issued');
            $table->bigInteger('created_by');
            $table->bigInteger('updated_by')->nullable();
            
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE'). '.users');
        });
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('biometrics');
    }
}
