<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateHistories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('hrjp_db')->table('position_histories', function(Blueprint $table){
            $table->integer('created_by')->nullable()->after('position_status');
            $table->integer('updated_by')->nullable()->after('created_by');
        });

        Schema::connection('adg_db')->table('corporation_histories', function(Blueprint $table){
            $table->integer('created_by')->nullable()->after('corporation_status');
            $table->integer('updated_by')->nullable()->after('created_by');
        });

        Schema::connection('adg_db')->table('branch_histories', function(Blueprint $table){
            $table->integer('created_by')->nullable()->after('branch_status');
            $table->integer('updated_by')->nullable()->after('created_by');
        });

        Schema::connection('adg_db')->table('division_histories', function(Blueprint $table){
            $table->integer('created_by')->nullable()->after('division_status');
            $table->integer('updated_by')->nullable()->after('created_by');
        });

        Schema::connection('adg_db')->table('department_histories', function(Blueprint $table){
            $table->integer('created_by')->nullable()->after('department_status');
            $table->integer('updated_by')->nullable()->after('created_by');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('hrjp_db')->table('position_histories', function(Blueprint $table){
            $table->dropColumn(['created_by','updated_by']);
        });

        Schema::connection('adg_db')->table('corporation_histories', function(Blueprint $table){
            $table->dropColumn(['created_by','updated_by']);
        });

        Schema::connection('adg_db')->table('branch_histories', function(Blueprint $table){
            $table->dropColumn(['created_by','updated_by']);
        });

        Schema::connection('adg_db')->table('division_histories', function(Blueprint $table){
            $table->dropColumn(['created_by','updated_by']);
        });

        Schema::connection('adg_db')->table('department_histories', function(Blueprint $table){
            $table->dropColumn(['created_by','updated_by']);
        });
    }
}
