<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExitInterviewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('exit_interviews', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->date('date');
            $table->text('attachment')->nullable();
            $table->tinyInteger('status')->comment('1 = ongoing, 2 = done');
            $table->text('remarks')->nullable();
            $table->bigInteger('created_by');
            $table->bigInteger('updated_by')->nullable();
            
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE'). '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('exit_interviews');
    }
}
