<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTerminalLeaveBenefitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('terminal_leave_benefits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('leave_id');
            $table->decimal('computed_amount');

            $table->foreign('leave_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leaves');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('terminal_leave_benefits');
    }
}
