<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMonetizedLeavesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('monetized_leave_benefits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('leave_monetization_id');
            $table->decimal('deducted_vacation_leave_balance');
            $table->decimal('deducted_sick_leave_balance');
            $table->decimal('vacation_leave_balance')->comment('Resulting balance of leave after monetization');
            $table->decimal('sick_leave_balance')->comment('Resulting balance of leave after monetization');
            $table->decimal('total_points');
            $table->decimal('monetized_amount');

            $table->foreign('leave_monetization_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_has_monetizations');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('monetized_leave_benefits');
    }
}
