<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveWithoutPayDeductionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('leave_without_pay_deductions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payroll_employee_id');
            $table->unsignedBigInteger('leave_without_pay_id');

            $table->foreign('payroll_employee_id')->references('id')->on(env('ADG_DB_DATABASE').'.payroll_employees');
            $table->foreign('leave_without_pay_id')->references('id')->on(env('ADG_DB_DATABASE').'.leave_without_pays');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('leave_without_pay_deductions');
    }
}
