<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClearanceCompliances extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('clearance_compliances', function (Blueprint $table) {
            $table->id();
            $table->unsignedbigInteger('user_id');
            $table->unsignedBigInteger('clearance_id');
            $table->unsignedBigInteger('department_id');
            $table->BigInteger('assigned_personal_id');
            $table->Text('action_item')->nullable();
            $table->text('attachment')->nullable();
            $table->timestamp('timestamp');
            $table->BigInteger('created_by');
            $table->BigInteger('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('clearance_id')->references('id')->on(env('ADG_DB_DATABASE').'.clearances');
            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE').'.departments');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('clearance_compliances');
    }
}
