<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClearances extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('clearances', function (Blueprint $table) {
            $table->id();
            $table->unsignedbigInteger('user_id');
            $table->date('start_date');
            $table->tinyInteger('status')->comment("1 = approved, 2 = declined, 3 = ongoing, 4 = for verification, 5 = pending");
            $table->bigInteger('created_by');
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('clearances');
    }
}
