<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveWithoutPaysLeavesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('leave_without_pays', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('leave_id');
            $table->decimal('deducted_points');

            $table->foreign('leave_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leaves');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('leave_without_pays');
    }
}
