<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveHasMonetizationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('leave_has_monetizations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('leave_id');
            $table->integer('type')->comment('1 = by days, 2 = by 50% leave credits');
            $table->integer('vacation_days')->nullable();
            $table->integer('sick_days')->nullable();

            $table->foreign('leave_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leaves');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('leave_has_monetizations');
    }
}
