<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeavesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('leaves', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('leave_subtype_id');
            $table->unsignedBigInteger('leave_detail_id')->nullable();
            $table->text('specified_details')->nullable();
            $table->integer('number_of_days')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->date('date_filed')->nullable();
            $table->date('date_approved')->nullable();
            $table->integer('commutation')->comment('1 = requested, 2 = not requested')->default(2);
            $table->integer('status')->comment('1 = approved, 2 = declined, 3 = for review')->default(3);
            $table->text('reason_purpose')->comment('1 = days with pay, 2 = days without pay, others = whole text')->nullable();
            $table->integer('save_status')->comment('1 = saved, 2 = submitted');

            $table->integer('created_by');
            $table->integer('updated_by');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE'). '.users');
            $table->foreign('leave_subtype_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_subtypes');
            $table->foreign('leave_detail_id')->references('id')->on(env('ADG_DB_DATABASE') . '.leave_details');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('leaves');
    }
}
