<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('leave_details', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('status')->comment('1 = enabled, 2 = disabled');
            $table->integer('purpose')->comment('1 = Vacation Leave/Special Privilege Leave, 2 = Sick Leave, 3 = Special Leave Benefits for Women, 4 = Study Leave, 5 = Other Purpose');
            $table->integer('type')->comment('1 = specified details, 2 = monetization, 3 = no added details');

            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('leave_details');
    }
}
