<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMandatoryContributionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('mandatory_contributions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('template_id');
            $table->string('name');
            $table->integer('type')->comment('1 = percentage, 2 = fixed value');
            $table->decimal('value')->default(0);
            $table->integer('status');

            $table->integer('created_by');
            $table->integer('updated_by');
            $table->foreign('template_id')->references('id')->on(env('ADG_DB_DATABASE'). '.mandatory_contribution_templates');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('mandatory_contributions');
    }
}
