<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWithholdingTaxesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('withholding_taxes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payroll_employee_id');
            $table->double('annual_basic_pay');
            $table->double('gsis_sss');
            $table->double('pagibig');
            $table->double('philhealth');
            $table->double('union_dues')->nullable();
            $table->double('taxable_basic_salary');
            $table->double('mid_year_bonus')->nullable();
            $table->double('year_end_bonus')->nullable();
            $table->double('pei')->nullable();
            $table->double('taxable_13th_month')->nullable();
            $table->double('taxable_compensation')->nullable();
            $table->integer('tax_exemption')->comment('1 = exempted, 2 = not exempted');
            $table->double('annual_tax_due')->nullable();
            $table->integer('tax_option')->comment('1 = NOT INCLUDED in 13th month, 2 = INCLUDED in 13th month ');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('withholding_taxes');
    }
}
