<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Trainings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('trainings', function (Blueprint $table) {
            $table->id();
            $table->string('training_id')->unique();
            $table->string('title');
            $table->string('subject');
            $table->timestamp('date_start')->nullable();
            $table->timestamp('date_end')->nullable();
            $table->unsignedBigInteger('training_type');
            $table->string('type_of_learning_development');
            $table->integer('service_obligation_year');
            $table->integer('service_obligation_month');
            $table->string('conducted_sponsored_by');
            $table->text('message')->nullable();
            $table->integer('active')->comment('1 = active, 2 = ongoing, 3 = completed');
            $table->boolean('is_manual_input');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('training_type')->references('id')->on(env('ADG_DB_DATABASE').'.training_type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('trainings');
    }
}
