<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveWithoutPaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('leave_without_pays', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payroll_employee_id');
            $table->date('date');
            $table->integer('minutes');
            $table->integer('type')->comment('1 = absent, 2 = late, 3 = undertime');
            $table->decimal('points');

            $table->foreign('payroll_employee_id')->references('id')->on('payroll_employees');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('leave_without_pays');
    }
}
