<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollEarningDeductionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('payroll_earning_deductions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payroll_employee_id');
            $table->string('name');
            $table->decimal('amount');
            $table->integer('type')->comment('1 = earning, 2 = deduction');
            $table->integer('category')->comment('1 = common/mandatory, 2 = loans, 3 = others');

            $table->foreign('payroll_employee_id')->references('id')->on('payroll_employees');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('payroll_earning_deductions');
    }
}
