<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('payroll_employees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payroll_id');
            $table->unsignedBigInteger('user_id');
            $table->decimal('days_worked');
            $table->integer('absences');
            $table->decimal('lates');
            $table->decimal('undertimes');
            $table->decimal('basic_pay');
            $table->decimal('gross_pay');
            $table->decimal('deductions');
            $table->decimal('net_pay');
            $table->integer('created_by');
            $table->integer('updated_by');

            $table->foreign('payroll_id')->references('id')->on('payrolls');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('payroll_employees');
    }
}
