<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePrivateSalariesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('private_salaries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_salary_id');
            $table->double('salary');
            $table->timestamps();
            $table->foreign('user_salary_id')->references('id')->on(env('ADG_DB_DATABASE').'.user_salaries');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('private_salaries');
    }
}
