<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePublicSalariesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('public_salaries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_salary_id');
            $table->unsignedBigInteger('salary_grade_id');
            $table->foreign('user_salary_id')->references('id')->on(env('ADG_DB_DATABASE').'.user_salaries');
            $table->foreign('salary_grade_id')->references('id')->on(env('ADG_DB_DATABASE').'.salary_grades');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('public_salaries');
    }
}
