<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserSalariesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('user_salaries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('account_number');
            $table->date('appointment_date')->now();
            $table->date('date_of_effectivity');
            $table->double('official_business_pay')->nullable();
            $table->string('e_cola')->nullable();
            $table->string('special_pay')->nullable();
            $table->string('load_allowance')->nullable();
            $table->string('transportation_allowance')->nullable();
            $table->string('branch_allowance')->nullable();
            $table->string('gate_allowance')->nullable();
            $table->string('rice_allowance')->nullable();
            $table->text('remarks')->nullable();
            $table->integer('withholding_tax_option')->comment('1 = NOT included in 13th month, 2 = INCLUDED in 13th month')->default(1);
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('adg_db')->dropIfExists('user_salaries');
    }
}
