<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('adg_db')->create('user_has_loans', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('loan_id');
            $table->double('amount');
            $table->string('terms_of_payment');
            $table->date('submission_date');
            $table->text('purpose_of_loan')->nullable();
            $table->integer('status')->comment('1 = pending, 2 = pre-approved, 3 = acknowledged, 4 = approved, 5 = declined, 6 = cancelled');
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('loan_id')->references('id')->on(env('ADG_DB_DATABASE').'.loans');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_has_loans');
    }
}
